---
title: Allow traffic from IP addresses in allowlist only · Cloudflare Web
  Application Firewall (WAF) docs
description: This example skips WAF rules for requests from IP addresses in an
  allowlist (defined using an IP list).
lastUpdated: 2025-08-27T15:11:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-ips-in-allowlist/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-ips-in-allowlist/index.md
---

This example skips WAF rules for requests from IP addresses in an allowlist (defined using an [IP list](https://developers.cloudflare.com/waf/tools/lists/custom-lists/#ip-lists)).

1. [Create an IP list](https://developers.cloudflare.com/waf/tools/lists/create-dashboard/) with the IP addresses for which you want to allow access.\
   For example, create an IP list named `allowed_ips` with one or more IP addresses. For more information on the accepted IP address formats, refer to [IP lists](https://developers.cloudflare.com/waf/tools/lists/custom-lists/#ip-lists).

2. [Create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) skipping all rules for any request from the IPs in the list you created (`allowed_ips` in the current example).

   * **Expression**: `(ip.src in $allowed_ips)`

   * **Action**: *Skip:*

     * *All remaining custom rules*

     * *Skip phases*:

       * *All rate limiting rules*
       * *All Super Bot Fight Mode rules*
       * *All managed rules*

Make sure the new rule appears before any other custom rules in the rules list.

## Other resources

* [Use case: Require known IP addresses in site admin area](https://developers.cloudflare.com/waf/custom-rules/use-cases/site-admin-only-known-ips/)
* [Available skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/)
