---
title: Redirect visitors to a new page URL · Cloudflare Rules docs
description: Create a redirect rule to redirect visitors from `/contact-us/` to
  the page's new path `/contacts/`.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-new-url/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-new-url/index.md
---

This example static redirect for zone `example.com` will redirect visitors requesting the `/contact-us/` page to the new page URL `/contacts/`.

**When incoming requests match**

* **Field:** *URI Path*
* **Operator:** *equals*
* **Value:** `/contact-us/`

If you are using the Expression Editor, enter the following expression:\
`http.request.uri.path eq "/contact-us/"`

**Then**

* **Type:** *Static*
* **URL:** `/contacts/`
* **Status code:** *301*
* **Preserve query string:** Enabled

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `example.com/contact-us/` | `example.com/contacts/` | `301` |
| `example.com/contact-us/?state=TX` | `example.com/contacts/?state=TX` | `301` |
| `example.com/team/` | (unchanged) | n/a |
