---
title: Create an Advanced DDoS Protection rule · Cloudflare DDoS Protection docs
description: "To create a SYN flood rule or an out-of-state TCP rule:"
lastUpdated: 2025-09-03T18:12:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/how-to/create-rule/
  md: https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/how-to/create-rule/index.md
---

## Create an Advanced TCP Protection rule

To create a [SYN flood rule](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/#syn-flood-protection) or an [out-of-state TCP](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/#out-of-state-tcp-protection) rule:

1. In the Cloudflare dashboard, go to the **L3/4 DDoS protection** page.

   [Go to **DDoS Managed Rules**](https://dash.cloudflare.com/?to=/:account/network-security/ddos)

2. Go to **Advanced Protection** > **Advanced TCP Protection**.

3. Depending on the rule you are creating, do one of the following:

   * Under **SYN Flood Protection**, select **Create SYN flood rule**.
   * Under **Out-of-state TCP Protection**, select **Create out-of-state TCP rule**.

4. In **Mode**, select a [mode](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#mode) for the rule.

5. Under **Set scope**, select a [scope](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#scope) for the rule. If you choose to apply the rule to a subset of incoming packets, select a region or a data center.

6. Under **Sensitivity**, define the [burst sensitivity](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#burst-sensitivity) and [rate sensitivity](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#rate-sensitivity) of the rule (by default, *Medium*). The sensitivity levels are based on the initially configured thresholds for your specific case.

7. Select **Deploy**.

Note

Filters take precedence over rules. For details on how the execution mode is determined, refer to [Determining the execution mode](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#determining-the-execution-mode).

## Create an Advanced DNS Protection rule

1. In the Cloudflare dashboard, go to the **L3/4 DDoS protection** page.

   [Go to **DDoS Managed Rules**](https://dash.cloudflare.com/?to=/:account/network-security/ddos)

2. Go to **Advanced Protection** > **General settings**.

3. Add the prefixes you wish to onboard. Advanced DNS Protection will only be applied to the prefixes you onboard. If you already onboarded the desired prefixes when you configured Advanced TCP Protection, you do not need to take any other action.

   Note

   Currently, the list of onboarded prefixes is shared with Advanced TCP Protection. Any onboarded prefixes will be subject to both Advanced TCP Protection and Advanced DNS Protection, assuming that your account team has done the initial configuration of both systems. However, you can leave Advanced TCP Protection in monitoring mode.

4. Go to **Advanced DNS Protection**.

5. Select **Create Advanced DNS Protection rule**.

6. In **Mode**, select a mode for the rule.

7. Under **Set scope**, select a [scope](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#scope) to determine the range of packets that will be affected by the rule.

8. Under **Sensitivity**, define the [burst sensitivity](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#burst-sensitivity), [rate sensitivity](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#rate-sensitivity), and [profile sensitivity](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/concepts/#profile-sensitivity) to determine when to initiate mitigation. 9. Select **Deploy**.
